/*
 * Decompiled with CFR 0.152.
 */
package com.zchar.uniapp.plugin.mogu.utils;

import com.alibaba.fastjson.JSONObject;

public class Res {
    private int code;
    private Object data;
    private String method;
    private String message;

    public Res(int code, String method, String message, Object data) {
        this.method = method;
        this.message = message;
        this.code = code;
        this.data = data;
    }

    private JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("code", (Object)this.code);
            jsonObject.put("method", (Object)this.method);
            jsonObject.put("message", (Object)this.message);
            jsonObject.put("data", this.data);
        }
        catch (Exception e) {
            jsonObject.put("data", (Object)e.getMessage());
        }
        finally {
            return jsonObject;
        }
    }

    public static JSONObject returnSuccess(String method, Object data) {
        if (data == null) {
            data = true;
        }
        Res res = new Res(200, method, null, data);
        return res.toJSONObject();
    }

    public static JSONObject returnError(String method, String message) {
        Res res = new Res(400, method, message, null);
        return res.toJSONObject();
    }

    public static JSONObject returnError(String method, Throwable exception) {
        Res res = new Res(400, method, Res.getExceptionMessage(exception), null);
        return res.toJSONObject();
    }

    public static JSONObject sendSuccess(String method, Object data) {
        Res res = new Res(0, method, null, data);
        return res.toJSONObject();
    }

    public static JSONObject sendError(String method, String message) {
        Res res = new Res(-1, method, message, null);
        return res.toJSONObject();
    }

    public static JSONObject sendError(String method, Throwable exception) {
        Res res = new Res(-1, method, Res.getExceptionMessage(exception), null);
        return res.toJSONObject();
    }

    private static String getExceptionMessage(Throwable exception) {
        String exStr = exception.getMessage();
        if (exStr == null || exStr == "") {
            exStr = exception.toString();
        }
        return exStr;
    }
}

