/*
 * Decompiled with CFR 0.152.
 */
package com.zchar.uniapp.plugin;

import com.alibaba.fastjson.JSONObject;
import com.zchar.uniapp.plugin.mogu.utils.BadRequestException;
import com.zchar.uniapp.plugin.mogu.utils.Res;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.bridge.UniJSCallback;
import io.dcloud.feature.uniapp.common.UniModule;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;

public class TcpModule
extends UniModule {
    String SERVER_HOST = "";
    int SERVER_PORT = 0;
    Socket socket = null;
    BufferedWriter writer = null;
    DataInputStream reader = null;
    public UniJSCallback _callback = null;

    @UniJSMethod(uiThread=true)
    public void event(JSONObject json, UniJSCallback callback) {
        String method = json.getString("method");
        Object data = true;
        try {
            JSONObject param = json.getJSONObject("param");
            if (param == null) {
                param = new JSONObject();
            }
            if (this._callback == null) {
                this._callback = callback;
            }
            switch (method) {
                case "isConnected": {
                    data = this.isConnected();
                    break;
                }
                case "connect": {
                    this.connect(param);
                    data = this.SERVER_HOST + ":" + this.SERVER_PORT;
                    break;
                }
                case "send": {
                    this.send(param);
                    return;
                }
                case "close": {
                    this.close();
                }
            }
            this._callback.invokeAndKeepAlive((Object)Res.returnSuccess(method, data));
        }
        catch (Exception e) {
            this._callback.invokeAndKeepAlive((Object)Res.returnError(method, e));
        }
        catch (Throwable e) {
            this._callback.invokeAndKeepAlive((Object)Res.returnError(method, e));
        }
    }

    public boolean isConnected() {
        if (this.socket == null || this.socket.isClosed()) {
            return false;
        }
        return this.socket.isConnected();
    }

    public void connect(JSONObject param) throws IOException {
        this.SERVER_HOST = param.getString("ip");
        this.SERVER_PORT = param.getInteger("port");
        if (this.SERVER_HOST == null || "".equals(this.SERVER_HOST)) {
            throw new BadRequestException("\u7f3a\u5c11\u53c2\u6570ip");
        }
        if (this.SERVER_PORT == 0) {
            throw new BadRequestException("\u53c2\u6570port\u5fc5\u987b\u5927\u4e8e0");
        }
        if (this.isConnected()) {
            throw new BadRequestException("\u5ba2\u6237\u7aef\u5df2\u8fde\u63a5\uff0c\u4e0d\u80fd\u91cd\u590d\u8fde\u63a5\u3002");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TcpModule.this.socket = new Socket(TcpModule.this.SERVER_HOST, TcpModule.this.SERVER_PORT);
                    TcpModule.this.reader = new DataInputStream(TcpModule.this.socket.getInputStream());
                    TcpModule.this.writer = new BufferedWriter(new OutputStreamWriter(TcpModule.this.socket.getOutputStream(), "GBK"));
                    while (true) {
                        byte[] buffer;
                        if ((buffer = new byte[TcpModule.this.reader.available()]).length == 0) {
                            continue;
                        }
                        TcpModule.this.reader.read(buffer);
                        String msg = new String(buffer, "GBK");
                        TcpModule.this._callback.invokeAndKeepAlive((Object)Res.sendSuccess("receive", msg));
                    }
                }
                catch (IOException e) {
                    TcpModule.this._callback.invokeAndKeepAlive((Object)Res.returnError("connect", e));
                }
            }
        }).start();
    }

    public void send(JSONObject param) throws IOException {
        final String message = param.getString("message");
        if (message == null || "".equals(message)) {
            throw new BadRequestException("\u7f3a\u5c11\u53c2\u6570message");
        }
        if (!this.isConnected()) {
            throw new BadRequestException("\u5ba2\u6237\u7aef\u672a\u8fde\u63a5");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TcpModule.this.writer.write(message + "\n");
                    TcpModule.this.writer.flush();
                    TcpModule.this._callback.invokeAndKeepAlive((Object)Res.returnSuccess("send", message));
                }
                catch (IOException e) {
                    TcpModule.this._callback.invokeAndKeepAlive((Object)Res.returnError("send", e));
                }
            }
        }).start();
    }

    public void close() throws IOException {
        this.writer.close();
        this.socket.close();
        this.reader.close();
        this.socket = null;
    }
}

