/*
 * Decompiled with CFR 0.152.
 */
package com.zchar.uniapp.plugin;

import com.alibaba.fastjson.JSONObject;
import com.zchar.uniapp.plugin.mogu.utils.BadRequestException;
import com.zchar.uniapp.plugin.mogu.utils.Res;
import io.dcloud.feature.uniapp.annotation.UniJSMethod;
import io.dcloud.feature.uniapp.bridge.UniJSCallback;
import io.dcloud.feature.uniapp.common.UniModule;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class MqttModule
extends UniModule {
    private String url;
    private String username;
    private String password;
    private String clientId;
    public UniJSCallback _callback = null;
    private ScheduledExecutorService scheduler;
    private ScheduledExecutorService schedulerLocation;
    private MqttClient client;
    public MemoryPersistence memoryPersistence;

    @UniJSMethod(uiThread=true)
    public void event(JSONObject json, UniJSCallback callback) {
        String method = json.getString("method");
        Object data = true;
        try {
            JSONObject param = json.getJSONObject("param");
            if (param == null) {
                param = new JSONObject();
            }
            if (this._callback == null) {
                this._callback = callback;
            }
            switch (method) {
                case "isConnected": {
                    data = this.isConnected();
                    break;
                }
                case "connect": {
                    this.connect(param);
                    data = this.url + ", " + this.username + "@***, " + this.clientId + ".";
                    break;
                }
                case "subscribe": {
                    this.subscribe(param);
                    break;
                }
                case "unsubscribe": {
                    this.unsubscribe(param);
                    break;
                }
                case "send": {
                    this.send(param);
                    return;
                }
                case "close": {
                    this.close();
                }
            }
            this._callback.invokeAndKeepAlive((Object)Res.returnSuccess(method, data));
        }
        catch (Exception e) {
            this._callback.invokeAndKeepAlive((Object)Res.returnError(method, e));
        }
        catch (Throwable e) {
            this._callback.invokeAndKeepAlive((Object)Res.returnError(method, e));
        }
    }

    public boolean isConnected() {
        if (this.client == null) {
            return false;
        }
        return this.client.isConnected();
    }

    public void connect(JSONObject param) {
        this.url = param.getString("url");
        this.username = param.getString("username");
        this.password = param.getString("password");
        this.clientId = param.getString("clientId");
        if (this.url == null || "".equals(this.url)) {
            throw new BadRequestException("\u7f3a\u5c11\u53c2\u6570url");
        }
        if (this.username == null || "".equals(this.username)) {
            throw new BadRequestException("\u7f3a\u5c11\u53c2\u6570username");
        }
        if (this.password == null || "".equals(this.password)) {
            throw new BadRequestException("\u7f3a\u5c11\u53c2\u6570password");
        }
        if (this.clientId == null || "".equals(this.clientId)) {
            throw new BadRequestException("\u7f3a\u5c11\u53c2\u6570clientId");
        }
        if (this.isConnected()) {
            throw new BadRequestException("\u5ba2\u6237\u7aef\u5df2\u8fde\u63a5\uff0c\u4e0d\u80fd\u91cd\u590d\u8fde\u63a5\u3002");
        }
        this.Mqtt_connect();
        this.startReconnect();
    }

    private void Mqtt_connect() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (MqttModule.this.client == null) {
                    try {
                        MqttModule.this.Mqtt_init();
                    }
                    catch (MqttException e) {
                        MqttModule.this._callback.invokeAndKeepAlive((Object)Res.returnError("connect", e));
                    }
                }
                try {
                    if (!MqttModule.this.client.isConnected()) {
                        MqttConnectOptions options = new MqttConnectOptions();
                        options.setCleanSession(false);
                        options.setUserName(MqttModule.this.username);
                        options.setPassword(MqttModule.this.password.toCharArray());
                        options.setConnectionTimeout(10);
                        options.setKeepAliveInterval(20);
                        MqttModule.this.client.connect(options);
                    }
                }
                catch (Exception e) {
                    MqttModule.this._callback.invokeAndKeepAlive((Object)Res.returnError("connect", e));
                }
            }
        }).start();
    }

    private void startReconnect() {
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (MqttModule.this.client == null || !MqttModule.this.client.isConnected()) {
                    MqttModule.this.Mqtt_connect();
                }
            }
        }, 3000L, 10000L, TimeUnit.MILLISECONDS);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("initialDelay", (Object)3000);
        jsonObject.put("period", (Object)10000);
        this._callback.invokeAndKeepAlive((Object)Res.sendSuccess("initReconnect", jsonObject));
    }

    public void subscribe(JSONObject param) throws MqttException {
        String topic = param.getString("topic");
        if (topic == null || "".equals(topic)) {
            throw new BadRequestException("\u7f3a\u5c11\u53c2\u6570topic");
        }
        if (this.client == null || !this.client.isConnected()) {
            throw new BadRequestException("\u5ba2\u6237\u7aef\u672a\u8fde\u63a5");
        }
        this.client.subscribe(topic, 1);
    }

    public void unsubscribe(JSONObject param) throws MqttException {
        String topic = param.getString("topic");
        if (topic == null || "".equals(topic)) {
            throw new BadRequestException("\u7f3a\u5c11\u53c2\u6570topic");
        }
        if (this.client == null || !this.client.isConnected()) {
            throw new BadRequestException("\u5ba2\u6237\u7aef\u672a\u8fde\u63a5");
        }
        this.client.unsubscribe(topic);
    }

    public void send(JSONObject param) throws MqttException {
        String topic = param.getString("topic");
        String message = param.getString("message");
        if (topic == null || "".equals(topic)) {
            throw new BadRequestException("\u7f3a\u5c11\u53c2\u6570topic");
        }
        if (message == null || "".equals(message)) {
            throw new BadRequestException("\u7f3a\u5c11\u53c2\u6570message");
        }
        if (this.client == null || !this.client.isConnected()) {
            throw new BadRequestException("\u5ba2\u6237\u7aef\u672a\u8fde\u63a5");
        }
        MqttMessage message2 = new MqttMessage();
        message2.setPayload(message.getBytes());
        this.client.publish(topic, message2);
    }

    public void close() throws MqttException {
        if (this.client == null || !this.client.isConnected()) {
            throw new BadRequestException("\u5ba2\u6237\u7aef\u672a\u8fde\u63a5");
        }
        if (null != this.memoryPersistence) {
            try {
                this.memoryPersistence.close();
            }
            catch (MqttPersistenceException e) {
                throw new BadRequestException((Exception)((Object)e));
            }
        } else {
            throw new BadRequestException("memoryPersistence is null");
        }
        if (this.client.isConnected()) {
            this.client.disconnect();
            this.client.close();
            this.client = null;
            if (this.scheduler != null) {
                this.scheduler.shutdown();
                this.scheduler = null;
            }
        } else {
            throw new BadRequestException("\u5ba2\u6237\u7aef\u672a\u8fde\u63a5");
        }
    }

    private void Mqtt_init() throws MqttException {
        this.memoryPersistence = new MemoryPersistence();
        this.client = new MqttClient(this.url, this.clientId, (MqttClientPersistence)this.memoryPersistence);
        this.client.setCallback(new MqttCallback(){

            public void connectionLost(Throwable cause) {
                MqttModule.this._callback.invokeAndKeepAlive((Object)Res.sendError("connectionLost", cause.toString()));
            }

            public void deliveryComplete(IMqttDeliveryToken token) {
                MqttModule.this._callback.invokeAndKeepAlive((Object)Res.sendSuccess("send", token.isComplete()));
            }

            public void messageArrived(String topicName, MqttMessage message) throws Exception {
                MqttModule.this._callback.invokeAndKeepAlive((Object)Res.sendSuccess("receive", message.toString()));
            }
        });
    }
}

